/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPCONNECTRESPONSE_H
#define QKNXNETIPCONNECTRESPONSE_H

#include <QtKnx/qknxnetip.h>
#include <QtKnx/qknxnetipcrd.h>
#include <QtKnx/qknxnetipframe.h>
#include <QtKnx/qknxnetiphpai.h>
#include <QtKnx/qtknxglobal.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxNetIpConnectResponseProxy final
{
public:
    QKnxNetIpConnectResponseProxy() = delete;
    ~QKnxNetIpConnectResponseProxy() = default;

    QKnxNetIpConnectResponseProxy(const QKnxNetIpFrame &&) = delete;
    explicit QKnxNetIpConnectResponseProxy(const QKnxNetIpFrame &frame);

    bool isValid() const;

    quint8 channelId() const;
    QKnxNetIp::Error status() const;
    QKnxNetIpHpai dataEndpoint() const;
    QKnxNetIpCrd responseData() const;

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder &setChannelId(quint8 channelId);
        Builder &setStatus(QKnxNetIp::Error status);
        Builder &setDataEndpoint(const QKnxNetIpHpai &hpai);
        Builder &setResponseData(const QKnxNetIpCrd &crd);

        QKnxNetIpFrame create() const;

    private:
        quint8 m_channelId { 0 };
        QKnxNetIp::Error m_status { QKnxNetIp::Error::None };
        QKnxNetIpHpai m_hpai;
        QKnxNetIpCrd m_crd;
    };
    static QKnxNetIpConnectResponseProxy::Builder builder();

private:
    const QKnxNetIpFrame &m_frame;
};

QT_END_NAMESPACE

#endif
